/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.util;

import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;

public class PADump
implements Serializable {
    private static final String TRACE_MASKD = "JDMPTSKD";
    private static final String TRACE_MASKF = "JDMPTSKF";
    private static final String TRACE_MASKT = "JDMPTSKT";
    private String[] m_dumpType = null;
    private String[] m_HMCContainingDump = null;
    private Integer[] m_problemNumber = null;
    private Calendar[] m_dumpDate = null;
    private String[] m_dumpSize = null;
    private String[] m_dumpName = null;
    private String[] m_owningSystem = null;
    private String[] m_rawDumpSize = null;

    public PADump() {
        this(null, null, null, null, null, null, null);
    }

    public PADump(String[] type, String[] HMCContainingDump, Integer[] problemNumber, Calendar[] date, String[] size, String[] name, String[] owningSystem) {
        this.m_dumpType = type;
        this.m_HMCContainingDump = HMCContainingDump;
        this.m_problemNumber = problemNumber;
        this.m_dumpDate = date;
        if (size != null && size.length > 0) {
            Trace.trace(TRACE_MASKD, "size [0] " + size[0]);
        }
        this.m_rawDumpSize = size;
        this.setDumpSize(size);
        this.m_dumpName = name;
        this.m_owningSystem = owningSystem;
    }

    public static void main(String[] args) {
    }

    public String toString() {
        String output = null;
        return output;
    }

    public void setDumpName(String[] s) {
        this.m_dumpName = s;
    }

    public String[] getDumpName() {
        return this.m_dumpName;
    }

    public void setDumpType(String[] s) {
        this.m_dumpType = s;
    }

    public String[] getDumpType() {
        return this.m_dumpType;
    }

    public void setHMCContainingDump(String[] s) {
        this.m_HMCContainingDump = s;
    }

    public String[] getHMCContainingDump() {
        return this.m_HMCContainingDump;
    }

    public String[] getOwningSystem() {
        return this.m_owningSystem;
    }

    public void setProblemNumber(Integer[] i) {
        this.m_problemNumber = i;
    }

    public Integer[] getProblemNumber() {
        return this.m_problemNumber;
    }

    public void setDumpDate(Calendar[] c) {
        this.m_dumpDate = c;
    }

    public Calendar[] getDumpDate() {
        return this.m_dumpDate;
    }

    public void setDumpSize(String[] s) {
        Trace.trace(TRACE_MASKT, "-> PADump.setDumpSize()");
        Integer IntegerGB = new Integer(0x40000000);
        Integer IntegerMB = new Integer(0x100000);
        Integer IntegerKB = new Integer(1024);
        float floatGB = IntegerGB.floatValue();
        float floatMB = IntegerMB.floatValue();
        float floatKB = IntegerKB.floatValue();
        if (s != null) {
            String[] inSize = null;
            Trace.trace(TRACE_MASKD, "s.length is " + s.length);
            if (s.length > 0) {
                inSize = new String[s.length];
            }
            for (int i = 0; i < s.length; ++i) {
                Trace.trace(TRACE_MASKD, "s [" + i + "] is " + s[i]);
                Float size = new Float(s[i]);
                float floatSize = size.floatValue();
                NumberFormat nf = NumberFormat.getInstance();
                DecimalFormat df = (DecimalFormat)nf;
                df.applyPattern("###.##");
                Float value = null;
                String formattedSize = new String();
                if (floatSize >= floatGB) {
                    value = new Float(floatSize / floatGB);
                    formattedSize = df.format(value.floatValue()) + " GB";
                } else if (floatSize >= floatMB && floatSize < floatGB) {
                    value = new Float(floatSize / floatMB);
                    formattedSize = df.format(value.floatValue()) + " MB";
                } else if (floatSize >= floatKB && floatSize < floatMB) {
                    value = new Float(floatSize / floatKB);
                    formattedSize = df.format(value.floatValue()) + " KB";
                } else {
                    formattedSize = s[i].equals("1") ? s[i] + " byte" : s[i] + " bytes";
                }
                Trace.trace(TRACE_MASKF, "-- formattedSize[" + i + "] is: " + formattedSize);
                inSize[i] = formattedSize;
            }
            this.m_dumpSize = inSize;
        }
        Trace.trace(TRACE_MASKT, "<- PADump.setDumpSize()");
    }

    public String[] getDumpSize() {
        return this.m_dumpSize;
    }

    public String[] getRawDumpSize() {
        return this.m_rawDumpSize;
    }
}

